<?php
$basic_exif_tag=array(
"檔案名稱"=>$exif['FILE']['FileName'],
"檔案類型"=>$exif['FILE']['FileType'],
"檔案格式"=>$exif['FILE']['MimeType'],
"檔案大小"=>formatBytes($exif['FILE']['FileSize']),
"檔案寬度"=>$exif['COMPUTED']['Width']." 像素",
"檔案高度"=>$exif['COMPUTED']['Height']." 像素",
"相機品牌"=>$exif['IFD0']['Make'],
"相機型號"=>$exif['IFD0']['Model'],
"拍攝日期"=>date("Y年m月d日 H:i:s",strtotime($exif['IFD0']['DateTime'])),
"方向"=>$exif['IFD0']['Orientation'],
"快門"=>$exif['EXIF']['ExposureTime'],
"感光度ISO"=>$exif['EXIF']['ISOSpeedRatings'],
"光圈"=>$exif['COMPUTED']['ApertureFNumber'],
"閃光燈"=>$exif['EXIF']['Flash'],
"焦距"=>$exif['EXIF']['FocalLength']."mm",
"曝光補償"=>$exif['EXIF']['ExposureBiasValue']."EV",
"經度"=>getGps($exif['GPS']["GPSLongitude"], $exif['GPS']['GPSLongitudeRef']),
"緯度"=>getGps($exif['GPS']["GPSLatitude"], $exif['GPS']['GPSLatitudeRef'])
);



$exif_tag=array(
"時間戳"=>date("Y-m-dH:i:s",$exif['FILE']['FileDateTime']),

"水平分辨率"=>$exif['IFD0']['XResolution'],
"垂直分辨率"=>$exif['IFD0']['YResolution'],
"創建軟件"=>$exif['IFD0']['Software'],
"修改時間"=>$exif['IFD0']['DateTime'],
"作者"=>$exif['IFD0']['Artist'],
"YCbCr位置控制"=>$exif['IFD0']['YCbCrPositioning'],
"版權"=>$exif['IFD0']['Copyright'],
"攝影版權"=>$exif['COMPUTED']['Copyright.Photographer'],
"編輯版權"=>$exif['COMPUTED']['Copyright.Editor'],
"Exif版本"=>$exif['EXIF']['ExifVersion'],
"FlashPix版本"=>"Ver.".number_format($exif['EXIF']['FlashPixVersion']/100,2),
"拍攝日期"=>date("Y年m月d日 H:i:s",strtotime($exif['IFD0']['DateTime'])),
"數字化時間"=>$exif['EXIF']['DateTimeDigitized'],
"相片寬度"=>$exif['COMPUTED']['Height'],
"相片高度"=>$exif['COMPUTED']['Width'],
"光圈"=>$exif['EXIF']['ApertureValue'],
"快門速度"=>$exif['EXIF']['ShutterSpeedValue'],
"快門光圈"=>$exif['COMPUTED']['ApertureFNumber'],
"最大光圈值"=>"F".$exif['EXIF']['MaxApertureValue'],
"曝光時間"=>$exif['EXIF']['ExposureTime'],
"F-Number"=>$exif['EXIF']['FNumber'],
"測光模式"=>$exif['EXIF']['MeteringMode'],
"光源"=>$exif['EXIF']['LightSource'],
"閃光燈"=>$exif['EXIF']['Flash'],
"曝光模式"=>($exif['EXIF']['ExposureMode']==1?"手動":"自動"),
"白平衡"=>($exif['EXIF']['WhiteBalance']==1?"手動":"自動"),
"曝光程序"=>$exif['EXIF']['ExposureProgram'],
"曝光補償"=>$exif['EXIF']['ExposureBiasValue']."EV",
"ISO感光度"=>$exif['EXIF']['ISOSpeedRatings'],
"份量配置"=>(bin2hex($exif['EXIF']['ComponentsConfiguration'])=="01020300"?"YCbCr":"RGB"),//'0x04,0x05,0x06,0x00'="RGB"'0x01,0x02,0x03,0x00'="YCbCr"
"圖像壓縮率"=>$exif['EXIF']['CompressedBitsPerPixel']."Bits/Pixel",
"對焦距離"=>$exif['COMPUTED']['FocusDistance']."m",
"焦距"=>$exif['EXIF']['FocalLength']."mm",
"等價35mm焦距"=>$exif['EXIF']['FocalLengthIn35mmFilm']."mm",
"經度"=>getGps($exif['GPS']["GPSLongitude"], $exif['GPS']['GPSLongitudeRef']),
"緯度"=>getGps($exif['GPS']["GPSLatitude"], $exif['GPS']['GPSLatitudeRef'])
);

//把 bytes 轉換成其他單位
function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');

    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);

    $bytes /= pow(1024, $pow);

    return round($bytes, $precision) . ' ' . $units[$pow];
}


function getGps($exifCoord, $hemi) {

    $degrees = count($exifCoord) > 0 ? gps2Num($exifCoord[0]) : 0;
    $minutes = count($exifCoord) > 1 ? gps2Num($exifCoord[1]) : 0;
    $seconds = count($exifCoord) > 2 ? gps2Num($exifCoord[2]) : 0;

    $flip = ($hemi == 'W' or $hemi == 'S') ? -1 : 1;

    return $flip * ($degrees + $minutes / 60);

}

function gps2Num($coordPart) {

    $parts = explode('/', $coordPart);

    if (count($parts) <= 0)
        return 0;

    if (count($parts) == 1)
        return $parts[0];

    return floatval($parts[0]) / floatval($parts[1]);
}

?>
