<?php

//列出所有tad_news資料（$kind="news","page"）
function list_tad_news($the_ncsn = "0", $kind = "news", $show_uid = "")
{
    global $xoopsDB, $xoopsModule, $xoopsUser, $xoopsOption, $xoopsModuleConfig, $tadnews, $xoopsTpl;

    if (!empty($show_uid)) {
        $tadnews->set_view_uid($show_uid);
    }

    $tadnews->set_only_one_ncsn(true);
    $tadnews->set_news_kind($kind);
    $tadnews->set_summary(0);
    $tadnews->set_show_mode("list");
    $tadnews->set_admin_tool(true);
    if (empty($the_ncsn) or $kind == "news") {
        $tadnews->set_show_num($xoopsModuleConfig['show_num']);
    }
    $tadnews->set_show_enable(0);
    //$tadnews->set_news_cate_select(1);
    //$tadnews->set_news_author_select(1);
    $tadnews->set_news_check_mode(1);
    $tadnews->chk_user_cate_power("pass");
    $options = $tadnews->get_tad_news_cate_option(0, 0, "", true, "", "1");

    if (!empty($the_ncsn)) {
        $tadnews->set_view_ncsn($the_ncsn);
        if ($kind == "page") {
            $tadnews->set_sort_tool(1);
            $page = 'page.php';
        } else {
            $page = 'main.php';
        }
    }

    $tadnews->get_news();
    $xoopsTpl->assign('options', $options);
    $xoopsTpl->assign('ncsn', $the_ncsn);
    $cate = $tadnews->get_tad_news_cate($the_ncsn);
    $xoopsTpl->assign('cate', $cate);

    if (!file_exists(XOOPS_ROOT_PATH . "/modules/tadtools/sweet_alert.php")) {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }
    include_once XOOPS_ROOT_PATH . "/modules/tadtools/sweet_alert.php";
    $sweet_alert      = new sweet_alert();
    $sweet_alert_code = $sweet_alert->render("delete_tad_news_cate_func", "{$page}?op=delete_tad_news_cate&ncsn=", 'ncsn');
}

//列出所有tad_news_cate資料
function list_tad_news_cate($of_ncsn = 0, $level = 0, $not_news = '0', $i = 0, $catearr = "")
{
    global $xoopsDB, $xoopsModule, $xoopsTpl, $tadnews;
    $old_level = $level;
    $left      = $level * 18 + 4;
    $level++;

    $sql    = "select * from " . $xoopsDB->prefix("tad_news_cate") . " where not_news='{$not_news}' and of_ncsn='{$of_ncsn}' order by sort";
    $result = $xoopsDB->query($sql) or web_error($sql);

    //$catearr="";

    //$i=0;
    while (list($ncsn, $of_ncsn, $nc_title, $enable_group, $enable_post_group, $sort, $cate_pic, $not_news) = $xoopsDB->fetchRow($result)) {

        $sql2          = "select count(*) from " . $xoopsDB->prefix("tad_news") . " where ncsn='{$ncsn}'";
        $result2       = $xoopsDB->query($sql2);
        list($counter) = $xoopsDB->fetchRow($result2);

        $pic    = (empty($cate_pic)) ? "../images/no_cover.png" : _TADNEWS_CATE_URL . "/{$cate_pic}";
        $g_txt  = $tadnews->txt_to_group_name($enable_group, _TADNEWS_ALL_OK, " , ");
        $gp_txt = $tadnews->txt_to_group_name($enable_post_group, _MA_TADNEWS_ONLY_ROOT, " , ");

        $new_kind    = ($not_news == '1') ? 0 : 1;
        $change_text = ($not_news == '1') ? _MA_TADNEWS_CHANGE_TO_NEWS : _MA_TADNEWS_CHANGE_TO_PAGE;

        $catearr[$i]['left']        = $left;
        $catearr[$i]['pic']         = $pic;
        $catearr[$i]['nc_title']    = $nc_title;
        $catearr[$i]['sort']        = $sort;
        $catearr[$i]['ncsn']        = $ncsn;
        $catearr[$i]['counter']     = $counter;
        $catearr[$i]['g_txt']       = $g_txt;
        $catearr[$i]['gp_txt']      = $gp_txt;
        $catearr[$i]['new_kind']    = $new_kind;
        $catearr[$i]['change_text'] = $change_text;
        $catearr[$i]['offset']      = empty($old_level) ? "" : "offset{$old_level}";

        $i++;

        $sub = list_tad_news_cate($ncsn, $level, $not_news, $i, $catearr);
        $i   = $sub['i'];
        if (!empty($sub['arr'])) {
            $catearr = $sub['arr'];
        }

    }
    //$xoopsTpl->assign( "cate" , $catearr) ;
    $all['i']   = $i;
    $all['arr'] = $catearr;
    return $all;
}

//縮圖上傳
function mk_thumb($ncsn = "", $col_name = "", $width = 100)
{
    global $xoopsDB;
    include XOOPS_ROOT_PATH . "/modules/tadtools/upload/class.upload.php";

    if (file_exists(_TADNEWS_CATE_DIR . "/{$ncsn}.png")) {
        unlink(_TADNEWS_CATE_DIR . "/{$ncsn}.png");
    }
    //die(_TADNEWS_CATE_DIR);
    $handle = new upload($_FILES[$col_name]);
    if ($handle->uploaded) {
        $handle->file_new_name_body = $ncsn;
        $handle->image_convert      = 'png';
        $handle->image_resize       = true;
        $handle->image_x            = $width;
        $handle->image_ratio_y      = true;
        $handle->file_overwrite     = true;
        $handle->process(_TADNEWS_CATE_DIR);
        $handle->auto_create_dir = true;
        if ($handle->processed) {
            $handle->clean();
            $sql = "update " . $xoopsDB->prefix("tad_news_cate") . " set  cate_pic = '{$ncsn}.png' where ncsn='$ncsn'";
            $xoopsDB->queryF($sql);
            return true;
        }
    }
    return false;
}

//新增資料到tad_news_cate中
function insert_tad_news_cate()
{
    global $xoopsDB, $xoopsModuleConfig;
    if (empty($_POST['enable_group']) or in_array("", $_POST['enable_group'])) {
        $enable_group = "";
    } else {
        $enable_group = implode(",", $_POST['enable_group']);
    }
    $enable_post_group = implode(",", $_POST['enable_post_group']);

    foreach ($_POST['setup'] as $key => $val) {
        $setup .= "{$key}=$val;";
    }
    $setup = substr($setup, 0, -1);

    $myts     = MyTextSanitizer::getInstance();
    $nc_title = $myts->addSlashes($_POST['nc_title']);

    $sql = "insert into " . $xoopsDB->prefix("tad_news_cate") . " (of_ncsn,nc_title,enable_group,enable_post_group,sort,not_news,setup) values('{$_POST['of_ncsn']}','{$nc_title}','{$enable_group}','{$enable_post_group}','{$_POST['sort']}','{$_POST['not_news']}','{$setup}')";
    $xoopsDB->queryF($sql) or web_error($sql);
    //取得最後新增資料的流水編號
    $ncsn = $xoopsDB->getInsertId();

    if (!empty($_FILES['cate_pic'])) {
        mk_thumb($ncsn, "cate_pic", $xoopsModuleConfig['cate_pic_width']);
    }

    return $ncsn;
}

//更新tad_news_cate某一筆資料
function update_tad_news_cate($ncsn = "")
{
    global $xoopsDB, $xoopsModuleConfig;
    if (empty($_POST['enable_group']) or in_array("", $_POST['enable_group'])) {
        $enable_group = "";
    } else {
        $enable_group = implode(",", $_POST['enable_group']);
    }
    $enable_post_group = implode(",", $_POST['enable_post_group']);

    foreach ($_POST['setup'] as $key => $val) {
        $setup .= "{$key}=$val;";
    }
    $setup = substr($setup, 0, -1);

    $sql = "update " . $xoopsDB->prefix("tad_news_cate") . " set  of_ncsn = '{$_POST['of_ncsn']}', nc_title = '{$_POST['nc_title']}', enable_group = '{$enable_group}', enable_post_group = '{$enable_post_group}',not_news='{$_POST['not_news']}',setup='{$setup}' where ncsn='$ncsn'";
    //die($sql);
    $xoopsDB->queryF($sql) or web_error($sql);

    if (!empty($_FILES['cate_pic']['name'])) {
        mk_thumb($ncsn, "cate_pic", $xoopsModuleConfig['cate_pic_width']);
    }

    $modhandler      = xoops_gethandler('module');
    $TadThemesModule = $modhandler->getByDirname("tad_themes");
    if ($TadThemesModule) {
        $sql     = "select menuid from " . $xoopsDB->prefix("tad_themes_menu") . " where `link_cate_name`='tadnews_page_cate' and `link_cate_sn`='{$ncsn}'";
        $result  = $xoopsDB->queryF($sql) or web_error($sql);
        $RowsNum = $xoopsDB->getRowsNum($result);
        if ($RowsNum > 0) {
            $sql = "update " . $xoopsDB->prefix("tad_themes_menu") . " set `itemname`='{$_POST['nc_title']}' where `link_cate_name`='tadnews_page_cate' and `link_cate_sn`='{$ncsn}'";
            $xoopsDB->queryF($sql) or web_error($sql);
        }
    }

    return $ncsn;
}

//刪除tad_news_cate某筆資料資料
function delete_tad_news_cate($ncsn = "")
{
    global $xoopsDB, $tadnews;

    $cate_org = $tadnews->get_tad_news_cate($ncsn);

    //先找看看底下有無分類，若有將其父分類變成原分類之父分類
    $sql = "update " . $xoopsDB->prefix("tad_news_cate") . "  set  of_ncsn = '{$cate_org['of_ncsn']}' where of_ncsn='$ncsn'";
    $xoopsDB->queryF($sql) or web_error($sql);

    $sql = "delete from " . $xoopsDB->prefix("tad_news_cate") . " where ncsn='$ncsn'";
    $xoopsDB->queryF($sql) or web_error($sql);
}

//轉換分類類型
function change_kind($ncsn = "", $not_news = "")
{
    global $xoopsDB, $xoopsModuleConfig;

    $sql = "update " . $xoopsDB->prefix("tad_news_cate") . " set not_news='{$not_news}' , of_ncsn='0' where ncsn ='{$ncsn}'";
    $xoopsDB->queryF($sql) or web_error($sql);

    //先找看看底下有無分類，若有將其也一起變
    $sub_cate = get_sub_cate($ncsn);
    if (!empty($sub_cate)) {
        $sql = "update " . $xoopsDB->prefix("tad_news_cate") . " set not_news='{$not_news}' where ncsn in ($sub_cate)";
        $xoopsDB->queryF($sql) or web_error($sql);
    }

    if ($not_news == 1) {
        header("location: page.php");
        exit;
    } else {
        header("location: main.php");
        exit;
    }
}

//找出底下的子分類
function get_sub_cate($of_ncsn = "")
{
    global $xoopsDB;
    $sql    = "select ncsn from " . $xoopsDB->prefix("tad_news_cate") . " where of_ncsn='$of_ncsn'";
    $result = $xoopsDB->query($sql) or web_error($sql);
    //echo "<p>$sql</p>";
    while (list($sub_ncsn) = $xoopsDB->fetchRow($result)) {
        $ccc = get_sub_cate($sub_ncsn);
        if (!empty($ccc)) {
            $aaa[] = $ccc;
        }

        $aaa[] = $sub_ncsn;
    }
    $bbb = implode(',', $aaa);
    //echo "<p style='color:red;'>$bbb</p>";

    return $bbb;
}

//搬移文章
function move_to_cate($ncsn = "", $to_ncsn = "")
{
    global $xoopsDB;

    $sql = "update " . $xoopsDB->prefix("tad_news") . " set ncsn='{$to_ncsn}' where ncsn='{$ncsn}'";
    $xoopsDB->queryF($sql) or web_error($sql);
    return;
}

//批次移動
function move_news($nsn_arr = array(), $ncsn = "")
{
    global $xoopsDB;
    if (empty($nsn_arr) or !is_array($nsn_arr)) {
        return;
    }

    foreach ($nsn_arr as $nsn) {
        $sql = "update " . $xoopsDB->prefix("tad_news") . " set ncsn='{$ncsn}' where nsn='{$nsn}'";
        $xoopsDB->queryF($sql) or web_error($sql);
    }
    return;
}

//批次刪除
function del_news($nsn_arr = array())
{
    global $xoopsDB, $tadnews;
    if (empty($nsn_arr) or !is_array($nsn_arr)) {
        return;
    }

    foreach ($nsn_arr as $nsn) {
        $sql = "delete from " . $xoopsDB->prefix("tad_news") . " where nsn='{$nsn}'";
        $xoopsDB->queryF($sql) or web_error($sql);
        $tadnews->delete_tad_news($nsn);
    }
    return;
}
