<?php
/**
 * Ugm Wifi module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ugm Wifi
 * @since      2.5
 * @author     郭俊良
 * @version    $Id $
 **/

/*-----------引入檔案區--------------*/
$isAdmin = true;
$xoopsOption['template_main'] = 'ugm_wifi_adm_main.html';
include_once "header.php";
include_once "../function.php";

/*-----------執行動作判斷區----------*/
include_once $GLOBALS['xoops']->path('/modules/system/include/functions.php');
$op = system_CleanVars($_REQUEST, 'op', '', 'string');
$sn = system_CleanVars($_REQUEST, 'sn', '', 'int');

switch ($op) {
/*---判斷動作請貼在下方---*/
//更新狀態
case "op_update_enable":
	op_update_enable();
	XoopsCache::clear();
	redirect_header($_SESSION['return'], 3, _BP_UPDATE_SUCCESS);
	break;
//新增資料
case "op_insert":
	$sn = op_insert();
	redirect_header($_SESSION['return'], 3, _BP_INSERT_SUCCESS);
	header("location: {$_SERVER['PHP_SELF']}?sn=$sn");
	exit;

//更新資料
case "op_update":
	op_update($sn);
	redirect_header($_SESSION['return'], 3, _BP_UPDATE_SUCCESS);
	exit;

case "op_form":
	op_form($sn);
	break;

case "op_delete":
	op_delete($sn);
	redirect_header($_SESSION['return'], 3, _BP_DELETE_SUCCESS);
	exit;

default:
	# ---- 目前網址 ----
	$_SESSION['return'] = getCurrentUrl();
	$op = "op_list";
	op_list();
	break;

	/*---判斷動作請貼在上方---*/
}

/*-----------秀出結果區--------------*/
$xoopsTpl->assign("isAdmin", true);
$xoopsTpl->assign("op", $op);
$xoTheme->addStylesheet(XOOPS_URL . '/modules/tadtools/css/xoops_adm3.css');
include_once 'footer.php';
/*-----------功能函數區--------------*/
###############################################################################
#  更新啟用
###############################################################################
function op_update_enable() {
	global $xoopsDB;
	#權限
	/***************************** 過瀘資料 *************************/
	$enable = intval($_GET['enable']);
	$sn = intval($_GET['sn']);
	/****************************************************************/
	//更新
	$sql = "update " . $xoopsDB->prefix("ugm_wifi") . " set  `enable` = '{$enable}' where `sn`='{$sn}'";
	$xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
	return;
}
#######################################################
#  取得收款狀態選單
#######################################################
function get_users_option() {
	global $xoopsDB; //		uname
	$myts = MyTextSanitizer::getInstance();
	$sql = "select a.uid,a.name,a.uname
          from      " . $xoopsDB->prefix("users") . "    as a
          left join " . $xoopsDB->prefix("ugm_wifi") . " as b on a.uid = b.uid
		  where b.enable is null
          order by a.`uid`"; //die($sql);
	$result = $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());

	$option = "<option value='' disabled  selected>請選擇會員名稱</option>\n";
	while ($row = $xoopsDB->fetchArray($result)) {
		$row['uid'] = intval($row['uid']);
		$row['name'] = $myts->addSlashes($row['name']);
		$row['uname'] = $myts->addSlashes($row['uname']);
		$row['name'] = $row['name'] ? $row['name'] : $row['uname'];
		$option .= "<option value='{$row['uid']}'>{$row['uid']} - {$row['name']}</option>\n";
	}
	return $option;
}

//ugm_wifi編輯表單
function op_form($sn = '') {
	global $xoopsDB, $xoopsTpl, $xoopsUser, $isAdmin;
	if (!$isAdmin) {
		redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
	}

	//抓取預設值
	if (!empty($sn)) {
		$DBV = get_ugm_wifi($sn);
		$DBV['users_option'] = "";
	} else {
		$DBV = array();
		$DBV['users_option'] = get_users_option();
		$DBV['uname'] = "";
	}

	//預設值設定

	//設定 sn 欄位的預設值
	$DBV['sn'] = !isset($DBV['sn']) ? "" : $DBV['sn'];
	//設定 uid 欄位的預設值
	// $user_uid = $xoopsUser ? $xoopsUser->uid() : "";
	$DBV['uid'] = !isset($DBV['uid']) ? "" : $DBV['uid'];
	//將 uid 編號轉換成使用者姓名（或帳號）
	if ($DBV['uid']) {
		$DBV['uname'] = XoopsUser::getUnameFromId($DBV['uid'], 1) ? XoopsUser::getUnameFromId($DBV['uid'], 1) : XoopsUser::getUnameFromId($DBV['uid'], 0);
	}

	//設定 password 欄位的預設值
	$DBV['password'] = !isset($DBV['password']) ? '' : $DBV['password'];
	//設定 enable 欄位的預設值
	$DBV['enable'] = !isset($DBV['enable']) ? '1' : $DBV['enable'];

	$DBV['op'] = empty($DBV['sn']) ? "op_insert" : "op_update";

	//套用formValidator驗證機制
	if (!file_exists(TADTOOLS_PATH . "/formValidator.php")) {
		redirect_header("index.php", 3, _TAD_NEED_TADTOOLS);
	}
	include_once TADTOOLS_PATH . "/formValidator.php";
	$formValidator = new formValidator("#myForm", true);
	$formValidator_code = $formValidator->render();

	//加入Token安全機制
	include_once XOOPS_ROOT_PATH . "/class/xoopsformloader.php";
	$token = new XoopsFormHiddenToken();
	$DBV['token_form'] = $token->render();

	$xoopsTpl->assign("DBV", $DBV);
}

//以流水號取得某筆ugm_wifi資料
function get_ugm_wifi($sn = '') {
	global $xoopsDB;

	if (empty($sn)) {
		return;
	}

	$sql = "select * from `" . $xoopsDB->prefix("ugm_wifi") . "`
    where `sn` = '{$sn}'";
	$result = $xoopsDB->query($sql) or web_error($sql);
	$data = $xoopsDB->fetchArray($result);
	return $data;
}

//新增資料到ugm_wifi中
function op_insert() {
	global $xoopsDB, $xoopsUser, $isAdmin;
	if (!$isAdmin) {
		redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
	}

	//XOOPS表單安全檢查
	if (!$GLOBALS['xoopsSecurity']->check()) {
		$error = implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
		redirect_header($_SERVER['PHP_SELF'], 3, $error);
	}

	$myts = MyTextSanitizer::getInstance();
	$sn = intval($_POST['sn']);
	//取得使用者編號
	$uid = intval($_POST['uid']);
	$password = $myts->addSlashes($_POST['password']);
	$enable = intval($_POST['enable']);

	if (checkUid($uid) and $password) {
		$sql = "insert into `" . $xoopsDB->prefix("ugm_wifi") . "` (
	        `uid`,
	        `password`,
	        `enable`
	    ) values(
	        '{$uid}',
	        '{$password}',
	        '{$enable}'
	    )";
		$xoopsDB->query($sql) or web_error($sql);

		//取得最後新增資料的流水編號
		$sn = $xoopsDB->getInsertId();
		return $sn;
	} else {
		redirect_header($_SESSION['return'], 3, _BP_INSERT_ERROR);
	}

}

###########################################
#
#
###########################################
function checkUid($uid = "") {
	global $xoopsDB;
	$sql = "select uid
          	from      " . $xoopsDB->prefix("users") . "
		  	where uid = '{$uid}'"; //die($sql);
	$result = $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
	list($uid) = $xoopsDB->fetchRow($result);
	if ($uid) {
		return true;
	}

	return false;
}

//更新ugm_wifi某一筆資料
function op_update($sn = '') {
	global $xoopsDB, $isAdmin, $xoopsUser;
	if (!$isAdmin) {
		redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
	}

	//XOOPS表單安全檢查
	if (!$GLOBALS['xoopsSecurity']->check()) {
		$error = implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
		redirect_header($_SERVER['PHP_SELF'], 3, $error);
	}

	$myts = MyTextSanitizer::getInstance();

	$sn = intval($_POST['sn']);
	$password = $myts->addSlashes($_POST['password']);
	$enable = intval($_POST['enable']);

	if ($password) {
		$sql = "update `" . $xoopsDB->prefix("ugm_wifi") . "` set
       			`password` = '{$password}',
       			`enable` = '{$enable}'
    			where `sn` = '$sn'";
		$xoopsDB->queryF($sql) or web_error($sql);
		return $sn;
	} else {
		redirect_header($_SESSION['return'], 3, _BP_UPDATE_ERROR);
	}

}

//刪除ugm_wifi某筆資料資料
function op_delete($sn = '') {
	global $xoopsDB, $isAdmin;
	if (!$isAdmin) {
		redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
	}

	if (empty($sn)) {
		return;
	}

	$sql = "delete from `" . $xoopsDB->prefix("ugm_wifi") . "`
    where `sn` = '{$sn}'";
	$xoopsDB->queryF($sql) or web_error($sql);

}

//以流水號秀出某筆ugm_wifi資料內容
function op_show($sn = '') {
	global $xoopsDB, $xoopsTpl, $isAdmin;

	if (empty($sn)) {
		return;
	} else {
		$sn = intval($sn);
	}

	$myts = MyTextSanitizer::getInstance();

	$sql = "select * from `" . $xoopsDB->prefix("ugm_wifi") . "`
    where `sn` = '{$sn}' ";
	$result = $xoopsDB->query($sql) or web_error($sql);
	$row = $xoopsDB->fetchArray($result);

	//以下會產生這些變數： $sn, $uid, $password, $enable
	foreach ($row as $k => $v) {
		$$k = $v;
	}

	//將 uid 編號轉換成使用者姓名（或帳號）
	$uname = XoopsUser::getUnameFromId($uid, 1);
	if (empty($uname)) {
		$uname = XoopsUser::getUnameFromId($uid, 0);
	}

	//將是/否選項轉換為圖示
	$enable = ($enable == 1) ? '<img src="' . XOOPS_URL . '/modules/ugm_wifi/images/yes.gif" alt="' . _YES . '" title="' . _YES . '">' : '<img src="' . XOOPS_URL . '/modules/ugm_wifi/images/no.gif" alt="' . _NO . '" title="' . _NO . '">';

	//過濾讀出的變數值
	$password = $myts->htmlSpecialChars($password);

	$xoopsTpl->assign('sn', $sn);
	$xoopsTpl->assign('uname', $uname);
	$xoopsTpl->assign('password', $password);
	$xoopsTpl->assign('enable', $enable);

	$xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
	$xoopsTpl->assign('now_op', 'op_show');
}

//列出所有ugm_wifi資料
function op_list() {
	global $xoopsDB, $xoopsTpl, $isAdmin;

	$myts = MyTextSanitizer::getInstance();

	$sql = "select *
            from `" . $xoopsDB->prefix("ugm_wifi") . "`
            order by uid ";

	//getPageBar($原sql語法, 每頁顯示幾筆資料, 最多顯示幾個頁數選項);
	$PageBar = getPageBar($sql, 20, 10);
	$sql = $PageBar['sql'];
	$total = $PageBar['total'];
	$bar = $total > 20 ? $PageBar['bar'] : "";

	$result = $xoopsDB->query($sql) or web_error($sql);

	$rows = array();
	$i = 0;
	while ($row = $xoopsDB->fetchArray($result)) {
		//以下會產生這些變數： $sn, $uid, $password, $enable
		$row['uid'] = intval($row['uid']);

		//將 uid 編號轉換成使用者姓名（或帳號）
		$row['uname'] = XoopsUser::getUnameFromId($row['uid'], 1) ? XoopsUser::getUnameFromId($row['uid'], 1) : XoopsUser::getUnameFromId($row['uid'], 0);

		//將是/否選項轉換為圖示
		$row['enable'] = intval($row['enable']);

		//過濾讀出的變數值
		$row['password'] = $myts->htmlSpecialChars($row['password']);
		$row['sn'] = intval($row['sn']);
		$rows[] = $row;
	}

	//刪除確認的JS
	if (!file_exists(XOOPS_ROOT_PATH . "/modules/tadtools/sweet_alert.php")) {
		redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
	}
	include_once XOOPS_ROOT_PATH . "/modules/tadtools/sweet_alert.php";
	$sweet_alert_obj = new sweet_alert();
	$op_delete_func = $sweet_alert_obj->render('op_delete_func',
		"{$_SERVER['PHP_SELF']}?op=op_delete&sn=", "sn");
	$xoopsTpl->assign('op_delete_func', $op_delete_func);

	$xoopsTpl->assign('bar', $bar);
	$xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
	$xoopsTpl->assign('isAdmin', $isAdmin);
	$xoopsTpl->assign('rows', $rows);
}
