<?php
/*-----------引入檔案區--------------*/
include_once "../../mainfile.php";
include_once XOOPS_ROOT_PATH . "/modules/tadnews/language/{$xoopsConfig['language']}/main.php";
include_once XOOPS_ROOT_PATH . "/modules/tadnews/language/{$xoopsConfig['language']}/modinfo.php";
include_once XOOPS_ROOT_PATH . "/modules/system/language/{$xoopsConfig['language']}/blocks.php";
include_once XOOPS_ROOT_PATH . "/modules/tadnews/function.php";

/*-----------function區--------------*/

function list_tadnews($ncsn = '')
{
    global $xoopsModuleConfig, $tadnews;

    $num = (!empty($_POST['n'])) ? intval($_POST['n']) : 10;
    $p = (!empty($_POST['p'])) ? intval($_POST['p']) : 0;
    $start = $p * $num;

    $tadnews->set_show_num($num);
    $tadnews->set_skip_news($start);
    $tadnews->set_news_kind('news');
    $tadnews->set_summary($xoopsModuleConfig['summary_lengths']);
    if ($ncsn > 0) {
        $tadnews->set_view_ncsn($ncsn);
        $tadnews->set_show_mode($xoopsModuleConfig['cate_show_mode']);
        $ncsn_param = "&ncsn={$ncsn}";
    } else {
        $tadnews->set_show_mode($xoopsModuleConfig['show_mode']);
    }
    //$tadnews->set_title_length(20);
    $tadnews->set_cover(true, 'db');

    $tnews = $tadnews->get_news('return');

    $all_news = "";

    foreach ($tnews['page'] as $news) {
        $content = strip_tags($news['content']);
        $item_image = (empty($news['image_thumb'])) ? "" : "<div class='item-media'><img data-src='{$news['image_thumb']}' class='lazy lazy-fadein'></div>";
        $all_news .= "
          <li>
              <a href='pda.php?nsn={$news['nsn']}{$ncsn_param}' class='item-link item-content'>
                  {$item_image}
                  <div class='item-inner'>
                      <div class='item-title-row'>
                          <div class='item-title'>{$news['news_title']}</div>
                          <div class='item-after'><span class='badge'>{$news['counter']}</span></div>
                      </div>
                      <div class='item-subtitle'>{$news['post_date']} &middot; {$news['cate_name']}</div>
                      <div class='item-text'>{$content}</div>
                  </div>
              </a>
          </li>
      ";
    }

    return $all_news;
}

//顯示單一新聞
function show_news($nsn = '', $ncsn = '')
{
    global $xoopsUser, $xoopsModule, $xoopsModuleConfig, $tadnews;

    $module_name = $xoopsModule->getVar('name');
    $cate = $tadnews->get_tad_news_cate($ncsn);
    $navbar_title = (empty($ncsn)) ? "{$module_name}" : "{$cate['nc_title']}";

    $tadnews->set_view_nsn($nsn);
    $tadnews->set_cover(true, 'db');
    $tadnews->set_summary('full');
    //if($xoopsModuleConfig['use_star_rating']=='1'){
    //  $tadnews->set_use_star_rating(true);
    //}
    $news = $tadnews->get_news('return');

    $facebook_comments = facebook_comments($xoopsModuleConfig['facebook_comments_width'], 'tadnews', 'index.php', 'nsn', $nsn);

    $uid_name = XoopsUser::getUnameFromId($news['page'][0]['uid'], 1);
    $uid_name = (empty($uid_name)) ? XoopsUser::getUnameFromId($news['page'][0]['uid'], 0) : $uid_name;

    $sign_bg = (!empty($news['page'][0]['need_sign'])) ? "style='background-image:url(" . XOOPS_URL . "/modules/tadnews/images/sign_bg.png);background-position: right top;background-repeat: no-repeat;'" : "";

    $news_image = (!empty($news['page'][0]['image_thumb'])) ? "<div class='news-img'><img src='{$news['page'][0]['image_thumb']}' width='100%'></div>" : "";

    $main = "
<div class='navbar'>
    <div class='navbar-inner' data-page='show'>
        <div class='left'>
            <a href='#' class='back link'>
                <i class='icon icon-back'></i>
                <span>Back</span>
            </a>
        </div>
        <div class='center sliding'>{$navbar_title}</div>
        <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
    </div>
</div>
<div class='pages'>
    <div data-page='show' class='page no-tabbar'>
        <div class='page-content' id='news-wrap'>
            <div class='content-block'>
                <div class='content-block-inner'>
                    <div id='news-title' $sign_bg>
                        <h1>{$news['page'][0]['news_title']}</h1>
                        <div id='news-info'>
                            {$news['page'][0]['prefix_tag']} {$news['page'][0]['post_date']} &middot; {$uid_name} &middot; {$news['page'][0]['cate_name']} &middot; " . _TADNEWS_HOT . "{$news['page'][0]['counter']}
                        </div>
                    </div>
                    <hr>
                    <div id='news-content'>
                        {$news_image} {$news['page'][0]['content']}
                    </div>
                    <div id='news-read-check'>{$news['page'][0]['have_read_chk']}</div>
                    <div id='news-attach'>{$news['page'][0]['files']}</div>
                    <div style='clear:both;height:10px;'></div>
                    <div id='news-toolbar'>{$news['page'][0]['fun']}</div>
                </div>
                {$facebook_comments}
            </div>
        </div>
        <div style='clear:both;'></div>
    </div>
</div>
    ";

    $tadnews->add_counter($nsn);

    return $main;
}

//取得分類下拉選單2
function get_tad_news_cate_list_m()
{
    global $xoopsDB;

    $list = "
        <div class='content-block-title'>" . _MD_TADNEWS_NEWS_CATE . "</div>
            <div class='list-block'>
                <ul>
        ";

    $sql = "select `ncsn`, `nc_title`, `not_news` from " . $xoopsDB->prefix("tad_news_cate") . " where `not_news` != '1' order by `sort`";
    $result = $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, show_error($sql));

    while (list($ncsn, $nc_title, $not_news) = $xoopsDB->fetchRow($result)) {
        $list .= "
            <li>
                <a href='pda.php?op=category&ncsn={$ncsn}' class='item-link item-content'>
                    <div class='item-inner'>
                        <div class='item-title'>{$nc_title}</div>
                    </div>
                </a>
            </li>
        ";
    }
    $list .= "</ul></div>";

    return $list;
}

//列出月份
function month_list_m()
{
    global $xoopsDB;

    $sql = "select left(start_day,7) , count(*) from " . $xoopsDB->prefix("tad_news") . " where enable='1' group by left(start_day,7) order by start_day desc";

    $result = $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, show_error($sql));

    $count = $xoopsDB->getRowsNum($result);

    $nodata = (empty($count)) ? "
        <li class='item-content'>
            <div class='item-inner'>
                <div class='item-title'>No data available.</div>
            </div>
        </li>" : "";

    $opt = "{$nodata}";

    while (list($ym, $count) = $xoopsDB->fetchRow($result)) {
        $opt .= "
            <li>
                <a href='pda.php?op=archive&date={$ym}' class='item-link item-content'>
                    <div class='item-inner'>
                        <div class='item-title'>" . str_replace("-", "" . _MD_TADNEWS_YEAR, $ym) . _MD_TADNEWS_MONTH . "</div>
                        <div class='item-after'><span class='badge'>{$count}</span></div>
                    </div>
                </a>
            </li>
        ";
    }

    return $opt;
}

//分月新聞
function archive_m($date = "")
{
    global $xoopsModuleConfig, $tadnews;

    if (empty($date)) {
        $date = date("Y-m");
    }

    $tadnews->set_news_kind("news");
    $tadnews->set_show_mode('list');
    $tadnews->set_show_month($date);
    $tadnews->set_show_enable(1);

    $tnews = $tadnews->get_news('return');

    $nodata = (empty($tnews['page'])) ? "
        <li class='item-content'>
            <div class='item-inner'>
                <div class='item-title'>No data available.</div>
            </div>
        </li>" : "";

    $date_title = to_utf8(str_replace("-", "" . _MD_TADNEWS_YEAR . " ", $date) . _MD_TADNEWS_MONTH . _MD_TADNEWS_NEWS_TITLE);

    $list = "{$nodata}";

    foreach ($tnews['page'] as $news) {
        $list .= "
          <li>
              <a href='pda.php?nsn={$news['nsn']}{$ncsn_param}' class='item-link item-content'>
                  <div class='item-inner'>
                      <div class='item-title-row'>
                          <div class='item-title'>{$news['news_title']}</div>
                          <div class='item-after'><span class='badge'>{$news['counter']}</span></div>
                      </div>
                      <div class='item-subtitle'>{$news['post_date']} &middot; {$news['cate_name']}</div>
                  </div>
              </a>
          </li>
        ";
    }

    return $list;
}

//列出newspaper資料
function list_newspaper_m()
{
    global $xoopsDB, $xoopsOption;

    $sql = "select a.npsn,a.number,b.title,a.np_date from " . $xoopsDB->prefix("tad_news_paper") . " as a ," . $xoopsDB->prefix("tad_news_paper_setup") . " as b where a.nps_sn=b.nps_sn and b.status='1' order by a.np_date desc";

    $result = $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, show_error($sql));

    $count = $xoopsDB->getRowsNum($result);

    $nodata = (empty($count)) ? "
        <li class='item-content'>
            <div class='item-inner'>
                <div class='item-title'>No data available.</div>
            </div>
        </li>" : "";

    $main = "{$nodata}";

    while (list($allnpsn, $number, $title, $np_date) = $xoopsDB->fetchRow($result)) {

        $np_title = $title . sprintf(_MD_TADNEWS_NP_TITLE, $number);
        $np_date = substr($np_date, 0, 10);
        $main .= "
            <li>
                <a href='pda.php?op=preview&npsn={$allnpsn}' class='item-link item-content'>
                    <div class='item-inner'>
                        <div class='item-title'>{$np_date} {$np_title}</div>
                    </div>
                </a>
            </li>
        ";

    }

    return $main;
}

//預覽電子報
function preview_newspaper_m($npsn = "")
{
    global $xoopsDB;
    if (empty($npsn)) {
        return;
    }

    $np = get_newspaper($npsn);
    $sql = "select title,head,foot,themes from " . $xoopsDB->prefix("tad_news_paper_setup") . " where nps_sn='{$np['nps_sn']}'";
    $result = $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, show_error($sql));
    list($title, $head, $foot, $themes) = $xoopsDB->fetchRow($result);

    $head = str_replace('{N}', $np['number'], $head);
    $head = str_replace('{T}', $np['np_title'], $head);
    $head = str_replace('{D}', substr($np['np_date'], 0, 10), $head);

    $main = "{$head}{$np['np_content']}{$foot}";

    return $main;
}

function member_m()
{
    global $xoopsDB, $xoopsUser;

    $main = "";
    if ($xoopsUser) {
        $avatar = $xoopsUser->user_avatar();
        $uid_name = $xoopsUser->name();
        if (empty($uid_name)) {
            $uid_name = $xoopsUser->uname();
        }
        $main = "
        <div class='content-block'>
            <div class='avatar'>
                <div class='avatar_pic'><img src='" . XOOPS_URL . "/uploads/{$avatar}'></div>
                <div class='avatar_name'>{$uid_name}</div>
            </div>
        </div>
        <div class='content-block-title'>" . _MAIN . "</div>
        <div class='list-block'>
            <ul>
                <li>
                    <a href='" . XOOPS_URL . "/admin.php' class='item-link item-content external'>
                        <div class='item-media'><span class='icon ion-wrench'></span></div>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MB_SYSTEM_ADMENU . "</div>
                        </div>
                    </a>
                </li>
                <li>
                    <a href='" . XOOPS_URL . "/user.php' class='item-link item-content external'>
                        <div class='item-media'><span class='icon ion-person'></span></div>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MB_SYSTEM_VACNT . "</div>
                        </div>
                    </a>
                </li>
                <li>
                    <a href='" . XOOPS_URL . "/edituser.php' class='item-link item-content external'>
                        <div class='item-media'><span class='icon ion-edit'></span></div>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MB_SYSTEM_EACNT . "</div>
                        </div>
                    </a>
                </li>
                <li>
                    <a href='" . XOOPS_URL . "/notifications.php' class='item-link item-content external'>
                        <div class='item-media'><span class='icon ion-information-circled'></span></div>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MB_SYSTEM_NOTIF . "</div>
                        </div>
                    </a>
                </li>
                <li>
                    <a href='" . XOOPS_URL . "/viewpmsg.php' class='item-link item-content external'>
                        <div class='item-media'><span class='icon ion-archive'></span></div>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MB_SYSTEM_INBOX . "</div>
                        </div>
                    </a>
                </li>
                <li>
                    <a href='" . XOOPS_URL . "/user.php?op=logout' class='item-link item-content external'>
                        <div class='item-media'><span class='icon ion-power'></span></div>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MB_SYSTEM_LOUT . "</div>
                        </div>
                    </a>
                </li>
            </ul>
        </div>

        ";
    } else {
        $tlogin = openid_login();
        foreach ($tlogin as $login) {
            if ($login['class'] == 'btn-fb' or $login['class'] == 'btn-gl') {
                $login_list .= "<a href='{$login['link']}' class='{$login['class']} button button-big external'>{$login['fa']}</a>";
            } else {
                $login_list .= "<a href='{$login['link']}' class='{$login['class']} external'><img src='{$login['img']}' alt='{$login['text']}'></a>";
            }
        }
        $main = "
        <div class='content-block'>
            <div class='avatar'>
                <a href='#' data-popup='.popup-login-form' class='open-popup'>
                    <div class='avatar_pic'><span class='ion-ios-person'></span></div>
                    <div class='avatar_name'>" . _GUESTS . "</div>
                </a>
            </div>
            <div class='login-button'><a href='#' data-popup='.popup-login-form' class='open-popup button button-big'>" . _LOGIN . "</a></div>
            <div class='openid-button'>{$login_list}</div>
        </div>
        ";
    }

    return $main;
}

function openid_login()
{
    global $xoopsConfig;
    $modhandler = xoops_gethandler('module');
    $config_handler = xoops_gethandler('config');

    $TadLoginXoopsModule = $modhandler->getByDirname("tad_login");
    if ($TadLoginXoopsModule) {
        include_once XOOPS_ROOT_PATH . "/modules/tad_login/function.php";
        include_once XOOPS_ROOT_PATH . "/modules/tad_login/language/{$xoopsConfig['language']}/county.php";
        $tad_login['facebook'] = facebook_login('return');
        $tad_login['google'] = google_login('return');

        $config_handler = xoops_gethandler('config');
        $modConfig = $config_handler->getConfigsByCat(0, $TadLoginXoopsModule->getVar('mid'));

        $auth_method = $modConfig['auth_method'];
        $i = 0;

        foreach ($auth_method as $method) {
            $method_const = "_" . strtoupper($method);
            $loginTitle = sprintf(_TAD_LOGIN_BY, constant($method_const));

            if ($method == "facebook") {
                $tlogin[$i]['link'] = $tad_login['facebook'];
                $tlogin[$i]['class'] = 'btn-fb';
                $tlogin[$i]['fa'] = '<span class="icon ion-social-facebook"></span> Facebook';
            } elseif ($method == "google") {
                $tlogin[$i]['link'] = $tad_login['google'];
                $tlogin[$i]['class'] = 'btn-gl';
                $tlogin[$i]['fa'] = '<span class="icon ion-social-google"></span> Google';
            } else {
                $tlogin[$i]['link'] = XOOPS_URL . "/modules/tad_login/index.php?login&op={$method}";
                $tlogin[$i]['class'] = 'btn-openid';
            }
            $tlogin[$i]['img'] = XOOPS_URL . "/modules/tad_login/images/{$method}.png";
            $tlogin[$i]['text'] = $loginTitle;

            $i++;
        }
    }
    return $tlogin;
}

/*-----------執行動作判斷區----------*/
include_once $GLOBALS['xoops']->path('/modules/system/include/functions.php');
$op = system_CleanVars($_REQUEST, 'op', '', 'string');
$ncsn = system_CleanVars($_REQUEST, 'ncsn', 0, 'int');
$nsn = system_CleanVars($_REQUEST, 'nsn', 0, 'int');
$npsn = system_CleanVars($_REQUEST, 'npsn', '', 'int');
$date = system_CleanVars($_REQUEST, 'date', '', 'date');
$date = (!isset($date)) ? date("Y-m") : date("Y-m", $date);

switch ($op) {

    //下載檔案
    case "tufdl":
        $files_sn = isset($_GET['files_sn']) ? intval($_GET['files_sn']) : "";
        $TadUpFiles->add_file_counter($files_sn, $hash = false);
        exit;
        break;

    case "month_list":
        $month_list = month_list_m($date);
        $main = "
            <!-- Top Navbar-->
            <div class='navbar theme-white color-white'>
                <div class='navbar-inner' data-page='month'>
                    <div class='left'>
                        <a href='#' class='back link'>
                            <i class='icon icon-back'></i>
                            <span>Back</span>
                        </a>
                    </div>
                    <div class='center sliding'>" . _MI_TADNEWS_ARCHIVE . "</div>
                    <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
                </div>
            </div>
            <div class='pages navbar-through'>
                <div data-page='month' class='month page'>
                    <div class='page-content'>
                        <div class='list-block'>
                            <ul>{$month_list}</ul>
                        </div>
                    </div>
                </div>
            </div>
            ";
        echo $main;
        exit;
        break;

    case "archive":
        $archive = archive_m($date);
        $date_title = to_utf8(str_replace("-", "" . _MD_TADNEWS_YEAR . " ", $date) . _MD_TADNEWS_MONTH);
        $main = "
            <!-- Top Navbar-->
            <div class='navbar theme-white color-white'>
                <div class='navbar-inner' data-page='archive'>
                    <div class='left'>
                        <a href='#' class='back link'>
                            <i class='icon icon-back'></i>
                            <span>Back</span>
                        </a>
                    </div>
                    <div class='center sliding'>{$date_title}</div>
                    <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
                </div>
            </div>
            <div class='pages navbar-through'>
                <div data-page='archive' class='archive page'>
                    <div class='page-content'>
                        <div class='list-block media-list'>
                            <ul>{$archive}</ul>
                        </div>
                    </div>
                </div>
            </div>
            ";
        echo $main;
        exit;
        break;

    case "newspaper":
        $newspaper = list_newspaper_m();
        $main = "
            <!-- Top Navbar-->
            <div class='navbar theme-white color-white'>
                <div class='navbar-inner' data-page='newspaper'>
                    <div class='left'>
                        <a href='#' class='back link'>
                            <i class='icon icon-back'></i>
                            <span>Back</span>
                        </a>
                    </div>
                    <div class='center sliding'>" . _MI_TADNEWS_NEWSPAPER . "</div>
                    <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
                </div>
            </div>
            <div class='pages navbar-through'>
                <div data-page='newspaper' class='newspaper page'>
                    <div class='page-content'>
                        <div class='list-block'>
                            <ul>{$newspaper}</ul>
                        </div>
                    </div>
                </div>
            </div>
            ";
        echo $main;
        exit;
        break;

    case "preview":
        $preview = preview_newspaper_m($npsn);
        $main = "
            <!-- Top Navbar-->
            <div class='navbar theme-white color-white'>
                <div class='navbar-inner' data-page='preview'>
                    <div class='left'>
                        <a href='#' class='back link'>
                            <i class='icon icon-back'></i>
                            <span>Back</span>
                        </a>
                    </div>
                    <div class='center sliding'>" . _MI_TADNEWS_NEWSPAPER . "</div>
                    <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
                </div>
            </div>
            <div class='pages navbar-through'>
                <div data-page='preview' class='preview page'>
                    <div class='page-content'>
                        <div class='content-block'>
                            <div class='content-block-inner'>
                                {$preview}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            ";
        echo $main;
        exit;
        break;

    case "category":
        $category = list_tadnews($ncsn);
        $cate = $tadnews->get_tad_news_cate($ncsn);
        $main = "
            <!-- Top Navbar-->
            <div class='navbar theme-white color-white'>
                <div class='navbar-inner' data-page='category'>
                    <div class='left'>
                        <a href='#' class='back link'>
                            <i class='icon icon-back'></i>
                            <span>Back</span>
                        </a>
                    </div>
                    <div class='center sliding'>{$cate['nc_title']}</div>
                    <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
                </div>
            </div>
            <div class='pages navbar-through'>
                <div data-page='category' class='category{$ncsn} page'>
                    <div class='page-content pull-to-refresh-content infinite-scroll'>
                        <div class='pull-to-refresh-layer'>
                            <div class='preloader'></div>
                            <div class='pull-to-refresh-arrow'></div>
                        </div>
                        <div class='list-block media-list cate-list'>
                            <ul>{$category}</ul>
                        </div>
                        <div class='infinite-scroll-preloader'>
                            <div class='preloader'></div>
                        </div>
                    </div>
                </div>
            </div>
            ";
        echo $main;
        exit;
        break;

    case "member":
        $member = member_m();
        $main = "
            <!-- Top Navbar-->
            <div class='navbar theme-white color-white'>
                <div class='navbar-inner' data-page='member'>
                    <div class='left'>
                        <a href='#' class='back link'>
                            <i class='icon icon-back'></i>
                            <span>Back</span>
                        </a>
                    </div>
                    <div class='center sliding'>" . _MB_SYSTEM_ADMENU . "</div>
                    <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
                </div>
            </div>
            <div class='pages navbar-through'>
                <div data-page='member' class='member page'>
                    <div class='page-content'>
                        {$member}
                    </div>
                </div>
            </div>
        ";
        echo $main;
        exit;
        break;

    case "load_more":
        $main = list_tadnews($ncsn);
        echo $main;
        exit;
        break;

    default:
        if (!empty($nsn)) {
            $main = show_news($nsn, $ncsn);
            echo $main;
            exit;
        } else {
            $main = list_tadnews($ncsn);
        }
        break;
}

/*-----------秀出結果區--------------*/
$module_name = $xoopsModule->getVar('name');
//分類下拉選單
$cate_list = get_tad_news_cate_list_m();

echo "
<!DOCTYPE html>
<html lang='" . _LANGCODE . "'>

<head>
    <meta charset='" . _CHARSET . "'>
    <meta name='viewport' content='width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no, minimal-ui'>
    <meta name='apple-mobile-web-app-capable' content='yes'>
    <meta name='apple-mobile-web-app-status-bar-style' content='black'>
    <title>{$module_name}</title>
    <link rel='stylesheet' href='" . XOOPS_URL . "/modules/tadnews/class/framework7/css/framework7.ios.min.css'>
    <link rel='stylesheet' href='" . XOOPS_URL . "/modules/tadnews/class/framework7/css/framework7.ios.colors.min.css'>
    <link rel='stylesheet' href='" . XOOPS_URL . "/modules/tadnews/class/framework7/css/ionicons.min.css'>
    <link rel='stylesheet' href='" . XOOPS_URL . "/modules/tadnews/class/framework7/css/my-app.css'>
</head>

<body>
    <div class='statusbar-overlay'></div>
    <div class='panel-overlay'></div>
    <div class='panel panel-right layout-dark panel-reveal'>
        <div class='navbar'>
            <div class='navbar-inner'>
                <div class='left'>
                    <a href='#' class='close-panel'><span class='ion-close'></span> Close</a>
                </div>
            </div>
        </div>
        <div class='list-block'>
            <ul>
                <li>
                    <a href='pda.php?op=month_list' class='item-link item-content'>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MI_TADNEWS_ARCHIVE . "</div>
                        </div>
                    </a>
                </li>
                <li>
                    <a href='pda.php?op=newspaper' class='item-link item-content'>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MI_TADNEWS_NEWSPAPER . "</div>
                        </div>
                    </a>
                </li>
                <li>
                    <a href='pda.php?op=member' class='item-link item-content'>
                        <div class='item-inner'>
                            <div class='item-title'>" . _MB_SYSTEM_ADMENU . "</div>
                        </div>
                    </a>
                </li>
            </ul>
        </div>
        {$cate_list}
    </div>
    <!-- Views -->
    <div class='views'>
        <div class='view view-main'>
            <!-- Top Navbar-->
            <div class='navbar theme-white color-white'>
                <div class='navbar-inner' data-page='index'>
                    <div class='left'><a href='pda.php' class='link icon-only external'><i class='icon ion-ios-home'></i></a></div>
                    <div class='center sliding'>{$module_name}</div>
                    <div class='right'><a href='#' data-panel='right' class='open-panel link icon-only'><i class='icon icon-bars'></i></a></div>
                </div>
            </div>
            <div class='pages navbar-through'>
                <div data-page='index' class='index page'>
                    <div class='page-content pull-to-refresh-content infinite-scroll'>
                        <div class='pull-to-refresh-layer'>
                            <div class='preloader'></div>
                            <div class='pull-to-refresh-arrow'></div>
                        </div>
                        <div class='list-block media-list index-list'>
                            <ul>{$main}</ul>
                        </div>
                        <div class='infinite-scroll-preloader'>
                            <div class='preloader'></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class='popup popup-login-form'>
        <div class='content-block'>
            <p><a href='#' class='close-popup'><span class='ion-close'></span> Close</a></p>
            <form method='post' action='" . XOOPS_URL . "/user.php' id='loginForm'>
                <div class='content-block-title'>" . _LOGIN . "</div>
                <div class='list-block'>
                    <ul>
                        <li>
                            <div class='item-content'>
                                <div class='item-media'><i class='icon icon-form-name'></i></div>
                                <div class='item-inner'>
                                    <div class='item-title label'>" . _USERNAME . "</div>
                                    <div class='item-input'>
                                        <input type='text' name='uname' placeholder=''>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class='item-content'>
                                <div class='item-media'><i class='icon icon-form-password'></i></div>
                                <div class='item-inner'>
                                    <div class='item-title label'>" . _PASSWORD . "</div>
                                    <div class='item-input'>
                                        <input type='password' name='pass' placeholder=''>
                                    </div>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <input type='hidden' value='/modules/tadnews/pda.php' name='xoops_redirect'>
                <input type='hidden' value='login' name='op'>
                <a href='#' onclick=\"document.getElementById('loginForm').submit();\" class='button button-fill external'>" . _SUBMIT . "</a>
            </form>
            </div>
    </div>
    <!-- Framework7 Library JS-->
    <script type='text/javascript' src='" . XOOPS_URL . "/modules/tadtools/jquery/jquery-1.11.1.min.js'></script>
    <script type='text/javascript' src='" . XOOPS_URL . "/modules/tadnews/class/framework7/js/framework7.min.js'></script>
    <script type='text/javascript' src='" . XOOPS_URL . "/modules/tadtools/fancyBox/source/jquery.fancybox.js?v=2.1.4'></script>
    <link rel='stylesheet' href='" . XOOPS_URL . "/modules/tadtools/fancyBox/source/jquery.fancybox.css?v=2.1.4'>
    <script type='text/javascript' src='" . XOOPS_URL . "/modules/tadnews/class/framework7/js/my-app.js'></script>
</body>

</html>

";
